function [ wcoh, tt, ff, cwts   ] = wcoh_signals( signals, params, ts )
%WCOH Computes wavelet coherence and wavelet transforms a signal
%   

%% Wavelet coherence

w_name = params.w_name;
w_scale = 4:0.5:200;      %scale parameter for wavelet... scale 1 is the finest (HF components); 
                                % scales less than 4 contradict Nyquist-Shannon theorem
t_start = 1;                %the first time instance to be analyzed...
N_sig = size(signals,2);
fs_o = params.fs_o;
fs_d = params.fs_d;

Q = round(fs_o/fs_d);       %downsampling factor
fs = fs_o/Q;                %true new sampling frequency
it = 1/fs;                  %sampling step (period)
dt = round(params.dt*fs);   

x = signals(:,1);
x = resample(x,1,Q);
Wx = cwt(x,w_scale,w_name)';
N_cwt = size(Wx,2);
N_t = size(signals,1);
cwts=zeros(N_t,N_sig,N_cwt);
cwts(:,1,:)=Wx;
t_end = size(Wx,1)-2*dt;    %the last time instance
t_step = params.t_step;wcoh_signals

for i = 2 : N_sig
    x = signals(:,i);
    x = resample(x,1,Q);
    cwts(:,i,:) = cwt(x,w_scale,w_name)'; 
end
c = 0;
for i = 1 : N_sig
    Wx = squeeze(cwts(:,i,:))';
    for j = i + 1 : N_sig
        Wy = squeeze(cwts(:,j,:))';

        %estimating localized "power spectra"
        for t_ind = t_start:t_step:t_end
            wx = Wx(:,t_ind:t_ind+2*dt);              %time localization of cwts'
            wy = Wy(:,t_ind:t_ind+2*dt);
            for s_ind = 1:size(wx,1)
                Sxx = sum(wx(s_ind,:).*conj(wx(s_ind,:)));       %the normalization by scale is omitted since non-important for soherence
                Syy = sum(wy(s_ind,:).*conj(wy(s_ind,:)));
                Sxy = sum(wx(s_ind,:).*conj(wy(s_ind,:)));
                wcoh_ij((t_ind-t_start)/t_step+1,s_ind) = abs(Sxy)^2/(Sxx*Syy);
            end
        end
    result.(sprintf('s%i_%i',i,j)) = wcoh_ij;
    c = c + 1;
    end
    
end

tt = (t_start:t_step:t_end)/fs + params.dt;       %time scale
ff = 2*fs./w_scale;                               %frequency scale
x = tt * fs_o;

wcoh = zeros(c,length(ts),length(w_scale));
c = 1;
for i = 1 : N_sig
    for j = i + 1 : N_sig
        w = result.(sprintf('s%i_%i',i,j));
        w = interp1(x, w, ts);
        wcoh(c,:,:) = w;
        c = c + 1;
        %wcoh(c,:,:) = result.(sprintf('s%i_%i',i,j)); %cwt(signals(:,i), params.scales, w_name)';
    end
end

N_s = length(params.scales);
cwts = zeros(N_t,N_sig,N_s);

for i = 1 : N_sig
    x = signals(:,i);
    cwts(:,i,:) = cwt(x,params.scales,'morl')'; 
end

end

