function [ G ] = rewire_graph( G, p, directed, exclude )
% REWIRE_GRAPH Randomly alters existing edges of a graph
%   
% PARAMETERS:
%
% G             The graph to rewire
% p             Probability that a edge will rewire
% directed      Is the graph directed? Default = false
% exclude       Edges to exclude from rewiring; Mx2; default = exclude none
%
% AUTHOR: Andrew Reid, MNI, 2014

if nargin < 3
   directed = false; 
end

N_vert = length(G);

if nargin < 4
   exclude = false(N_vert);
else
   exclude2 = false(N_vert);
   for i = 1 : size(exclude,1)
       idx = exclude(i,:);
       exclude2(idx(1),idx(2))=true;
       if ~directed
           exclude2(idx(2),idx(1))=true;
       end
   end
   exclude=exclude2;
   clear exclude2;
end

for i = 1 : N_vert
    j_s = 1;
    if ~directed, j_s = i+1; end
    for j = j_s : N_vert
        % If edge exits, see if it needs to be rewired
        if ~exclude(i,j) && G(i,j) && rand < p
            % If this vertex is fully connected, it can't be rewired
            if sum(G(i,:)) < N_vert
                G(i,j)=0;
                j_new = ceil(rand*N_vert);
                while j_new == j || j_new == i || G(i,j_new)==1, j_new = ceil(rand*N_vert); end
                G(i,j_new)=1;
                if ~directed
                    G(j,i)=0;
                    G(j_new,i)=1;
                end
            end
        end
       
    end
end

