function [ models ] = generate_wc_models_2_5_1_2( params, weights, delays, probs )
%GENERATE_WC_MODELS_2_5_1_1 Generates a set of 7-vertex models. The
%                           starting model has a single source and two 
%                           parallel streams. Edges are rewired with probabilities
%                           from the probs parameter. The network has a
%                           single external input to the first node, simulating
%                           two parallel streams.
%  
% Returns a vector of models, of size (length(weights) * params.n_delays * params.n_trials, 1)
%
% Models are assigned two additional parameters:
%
% graph         A graph of the network
% graph_pos     Geometric positions of the vertices (for rendering purposes)

model_params = wilson_cowan_model_params;
models = wilson_cowan_model(model_params);
models.graph=zeros(7);
models.graph_pos = get_sym_net_pos();
j = 1;
S = get_sym_net();
for i = 1 : params.n_trials
   
    model_params = wilson_cowan_model_params;
    model_params.input_gain=1;
    
     % Randomized pulse sequence
    if strcmp(params.external_input, 'pulse_train')
        model_params.input_signal = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                          params.durations(ceil(rand*length(params.durations))), ...
                                                          1, 1, params.sim_options.t_stop, ...
                                                          params.offsets(ceil(rand*length(params.offsets))));
    elseif strcmp(params.external_input, 'none')
        model_params.input_signal = zeros(params.sim_options.t_stop,1);
    end
    
    for p = 1 : params.n_probs
        % Same structure across weights and delays
        G = rewire_graph(S, probs(p), true);
        for l = 1 : params.n_delays
            D = repmat(delays(l),7);
            for k = 1 : params.n_weights;
                G_k = G * 0.5; % weights(k);
                model=wilson_cowan_model_from_graph(G_k,D,model_params,params.vertex_prototype);
                vertex = model.vertices(1);
                vertex.external_weight=weights(k);
                model.vertices(1)=vertex;
                model.graph = G_k;
                model.graph_pos = get_sym_net_pos();
                models(j,1) = model;
                j = j + 1;
            end
        end
    end
    
end

    % Generate 7-vertex graph starting with 
    function M = get_sym_net ()
       M = [[0 1 1 0 0 0 0]; ...
            [0 0 0 1 0 0 0]; ...
            [0 0 0 0 1 0 0]; ...
            [0 1 0 0 0 1 0]; ...
            [0 0 1 0 0 0 1]; ...
            [0 0 0 1 0 0 0]; ...
            [0 0 0 0 1 0 0]];
        
    end

    function M_pos = get_sym_net_pos ()

        M_pos = [[2 1];
                 [1 2];
                 [3 2];
                 [1 3];
                 [3 3];
                 [1 4];
                 [3 4]];
        
    end

end

