function [ models ] = generate_wc_models_2_4_1_1( params, weights, delays )
%GENERATE_WC_MODELS_2_4_1_1 Generates a set of 5-vertex models
%   Models are 5-vertex:
%                       Configuration: Input1 -> V1, Input2 -> V2
%                                      V1,V2 -> V3
%                                      V3 -> V4,V5
%
% Returns a vector of models, of size (length(weights) * params.n_delays * params.n_trials, 1)

N_w = params.n_weights;
N_d = params.n_delays;
model_params = wilson_cowan_model_params;
models = wilson_cowan_model(model_params);
j = 1;
for i = 1 : params.n_trials
   
    model_params = wilson_cowan_model_params;
    
    % Randomized pulse sequences
    if strcmp(params.external_input, 'pulse_train')
        model_params.input_signal(:,1) = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                    params.durations(ceil(rand*length(params.durations))), ...
                                                    1, 1, params.sim_options.t_stop, ...
                                                    params.offsets(ceil(rand*length(params.offsets))));
        model_params.input_signal(:,2) = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                    params.durations(ceil(rand*length(params.durations))), ...
                                                    1, 1, params.sim_options.t_stop, ...
                                                    params.offsets(ceil(rand*length(params.offsets))));
    elseif strcmp(params.external_input, 'none')
        model_params.input_signal = zeros(params.sim_options.t_stop,2);
    end
    
    model_params.input_gain=1;
    
    for l = 1 : N_d
        for k = 1 : N_w
            model = wilson_cowan_model(model_params);

            V1 = params.vertex_prototype;
            V1.label = 'V1';
            V1.external_weight = [1 0];
            model = wilson_cowan_add_vertex( model, V1 );

            V2 = params.vertex_prototype;
            V2.label = 'V2';
            V2.external_weight = [0 1];
            model = wilson_cowan_add_vertex( model, V2 );
            
            V3 = params.vertex_prototype;
            V3.label = 'V3';
            V3.external_weight = [0 0];
            model = wilson_cowan_add_vertex( model, V3 );
            
            V4 = params.vertex_prototype;
            V4.label = 'V4';
            V4.external_weight = [0 0];
            model = wilson_cowan_add_vertex( model, V4 );
            
            V5 = params.vertex_prototype;
            V5.label = 'V5';
            V5.external_weight = [0 0];
            model = wilson_cowan_add_vertex( model, V5 );

            % Edge V1 -> V2
            w = weights(k,1);
            d = delays(l,1);
            edge = params.edge_prototype;
            edge.from = 1;
            edge.to = 3;
            edge.weight = w;
            edge.delay = d;
            model = wilson_cowan_add_edge( model, edge );
            
            % Edge V2 -> V3
            w = weights(k,2);
            d = delays(l,2);
            edge = params.edge_prototype;
            edge.from = 2;
            edge.to = 3;
            edge.weight = w;
            edge.delay = d;
            model = wilson_cowan_add_edge( model, edge );
            
            % Edge V3 -> V4
            w = weights(k,3);
            d = delays(l,3);
            edge = params.edge_prototype;
            edge.from = 3;
            edge.to = 4;
            edge.weight = w;
            edge.delay = d;
            model = wilson_cowan_add_edge( model, edge );
            
            % Edge V3 -> V5
            w = weights(k,4);
            d = delays(l,4);
            edge = params.edge_prototype;
            edge.from = 3;
            edge.to = 5;
            edge.weight = w;
            edge.delay = d;
            model = wilson_cowan_add_edge( model, edge );

            models(j,1) = model;
            j = j + 1;
        end
    end
    
end

end

