function [ models ] = generate_wc_models_1_1_2( params, weights, delays )
%GENERATE_WC_MODELS_1_1 Generates a set of two-vertex models
%   Models are two-vertex, bidirectional (V1 -> V2 & V2 -> V1). See the 
%   wilson_cowan_runs script (S1.1.2) for details.
%
% weights - must be of size (params.sim_options.t_stop, 2)
%
% Returns a vector of models, of size (length(weights) * params.n_trials, 1)

if nargin < 3
   delays = 50; 
end

N_w = size(weights,1);
N_d = size(delays,1);
model_params = wilson_cowan_model_params;
models = wilson_cowan_model(model_params);
j = 1;
for i = 1 : params.n_trials
   
    % Randomized pulse sequence
    model_params.input_signal = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                params.durations(ceil(rand*length(params.durations))), ...
                                                1, 1, params.sim_options.t_stop, ...
                                                params.offsets(ceil(rand*length(params.offsets))));
    for d = 1 : N_d        
        delay_1 = delays(d,1);
        delay_2 = delays(d,2);
        for k = 1 : N_w
            model = wilson_cowan_model(model_params);

            V1 = params.vertex_prototype;
            V1.label = 'V1';
            V1.external_weight = 1;
            model = wilson_cowan_add_vertex( model, V1 );

            V2 = params.vertex_prototype;
            V2.label = 'V2';
            model = wilson_cowan_add_vertex( model, V2 );

            w = weights(k,1);
            edge = params.edge_prototype;
            edge.from = 1;
            edge.to = 2;
            edge.weight = w;
            edge.delay = delay_1;
            model = wilson_cowan_add_edge( model, edge );

            w = weights(k,2);
            edge = params.edge_prototype;
            edge.from = 2;
            edge.to = 1;
            edge.weight = w;
            edge.delay = delay_2;
            model = wilson_cowan_add_edge( model, edge );

            models(j,1) = model;
            j = j + 1;
        end
    end
    
end

end

