function [ models ] = generate_wc_models_1_1_2( params, weights, delays )
%GENERATE_WC_MODELS_1_1 Generates a set of two-vertex models
%   Models are two-vertex, bidirectional (V1 -> V2). See the 
%   wilson_cowan_runs script (S1.1.2) for details.
%
% weights, delays - must be of size (params.sim_options.t_stop, 1)
%
% Returns a vector of models, of size (length(weights) * params.n_delays * params.n_trials, 1)

N_w = params.n_weights;
N_d = params.n_delays;
model_params = wilson_cowan_model_params;
models = wilson_cowan_model(model_params);
j = 1;
for i = 1 : params.n_trials
   
    % Randomized pulse sequence
    if strcmp(params.external_input, 'pulse_train')
        model_params.input_signal = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                    params.durations(ceil(rand*length(params.durations))), ...
                                                    1, 1, params.sim_options.t_stop, ...
                                                    params.offsets(ceil(rand*length(params.offsets))));
    elseif strcmp(params.external_input, 'none')
        model_params.input_signal = zeros(params.sim_options.t_stop,1);
    end
    
    for l = 1 : N_d
        for k = 1 : N_w
            model = wilson_cowan_model(model_params);

            V1 = params.vertex_prototype;
            V1.label = 'V1';
            V1.external_weight = 1.5;
            model = wilson_cowan_add_vertex( model, V1 );

            V2 = params.vertex_prototype;
            V2.label = 'V2';
            model = wilson_cowan_add_vertex( model, V2 );

            % Edge V1 -> V2
            w = weights(k,1);
            d = delays(l,1);
            edge = params.edge_prototype;
            edge.from = 1;
            edge.to = 2;
            edge.weight = w;
            edge.delay = d;
            model = wilson_cowan_add_edge( model, edge );
            
            % Edge V2 -> V1
            w = weights(k,2);
            d = delays(l,2);
            edge = params.edge_prototype;
            edge.from = 2;
            edge.to = 1;
            edge.weight = w;
            edge.delay = d;
            model = wilson_cowan_add_edge( model, edge );

            models(j,1) = model;
            j = j + 1;
        end
    end
    
end

end

