function [ models ] = generate_wc_models_1_1_1( params, weights )
%GENERATE_WC_MODELS_1_1 Generates a set of two-vertex models
%   Models are two-vertex, unidirectional (V1 -> V2). See the 
%   wilson_cowan_runs script (S1.1.1) for details.
%
% weights - must be of size (params.sim_options.t_stop, 1)
%
% Returns a vector of models, of size (length(weights) * params.n_trials, 1)

N_w = length(weights);
model_params = wilson_cowan_model_params;
models = wilson_cowan_model(model_params);
j = 1;
for i = 1 : params.n_trials
   
    model_params = wilson_cowan_model_params;
    
    % Randomized pulse sequence
    if strcmp(params.external_input, 'pulse_train')
        model_params.input_signal = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                    params.durations(ceil(rand*length(params.durations))), ...
                                                    1, 1, params.sim_options.t_stop, ...
                                                    params.offsets(ceil(rand*length(params.offsets))));
    elseif strcmp(params.external_input, 'none')
        model_params.input_signal = zeros(params.sim_options.t_stop,1);
    end
                     
    for k = 1 : N_w
        model = wilson_cowan_model(model_params);
        
        V1 = params.vertex_prototype;
        V1.label = 'V1';
        V1.external_weight = 0.5;
        model = wilson_cowan_add_vertex( model, V1 );
        
        V2 = params.vertex_prototype;
        V2.label = 'V2';
        model = wilson_cowan_add_vertex( model, V2 );
        
        w = weights(k,1);
        edge = params.edge_prototype;
        edge.from = 1;
        edge.to = 2;
        edge.weight = w;
        model = wilson_cowan_add_edge( model, edge );
        
        models(j,1) = model;
        j = j + 1;
    end
    
end

end

