function [ models ] = generate_wc_models_1_0_2( params, betas )
%GENERATE_WC_MODELS_1_0_2 Generates a set of one-vertex models with varying betas
%
% betas - range of betas
%
% Returns a vector of models, of size (length(weights) * params.n_trials, 1)

N_b = length(betas);
model_params = wilson_cowan_model_params;
models = wilson_cowan_model(model_params);
j = 1;
for i = 1 : params.n_trials
   
    model_params = wilson_cowan_model_params;
    
    % Randomized pulse sequence
    if strcmp(params.external_input, 'pulse_train')
        model_params.input_signal = generate_pulse_train( params.delays(ceil(rand*length(params.delays))), ...
                                                          params.durations(ceil(rand*length(params.durations))), ...
                                                          1, 1, params.sim_options.t_stop, ...
                                                          params.offsets(ceil(rand*length(params.offsets))));
    elseif strcmp(params.external_input, 'none')
        model_params.input_signal = zeros(params.sim_options.t_stop,1);
    end
                     
    for k = 1 : N_b
        beta = betas(k,1);
        model_params.morph_params.beta = beta;
        model = wilson_cowan_model(model_params);
        
        V1 = params.vertex_prototype;
        V1.label = 'V1';
        V1.external_weight = 0.5;
        model = wilson_cowan_add_vertex( model, V1 );
        
        models(j,1) = model;
        j = j + 1;
    end
    
end

end

