function [t_val,y_val] = simple_ode2 ( P )

    vertex = wilson_cowan_vertex;
    
    E0 = 0;
    I0 = 0;
    N = length (P);
    
    p_ee = 1;
    p_ei = 1;
    p_ie = 1;
    p_ii = 0;
    
    tau_e = 100;
    tau_i = 200;

    [t_val,y_val] = ode45(@solve_wc,1:N,[0 E0 I0]);
    
    function dydt = solve_wc(t,y)
        tt = round(t);
        Pt = P(tt);
        Et = y(1);
        It = y(2);
        E = -Et + wc_fcn(p_ee*Et - p_ei*It + Pt);
        E = E / tau_e;
        I = -It + wc_fcn(p_ie*Et - p_ii*It + Pt);
        I = I / tau_i;
        A = E - I; 
        dydt = [ A; E; I ];
    end

    % Use appropriate sigmoidal function here
    function v = wc_fcn( v )
        
        v = tanh(v); 
        
    end

end

