function [  ] = set_moab_file( path, n_nodes, ppn, wall_time )
%SET_MOAB_FILE Writes/overwrites moab.m file for setting the 
%              number of nodes/processors per node for remote parallel
%              processing.
%
% Note: for Guillimin, this moab.m file must be located in the same
% directory as the script or function passed to the batch command. See
% https://support.clumeq.ca/index.php/guillimin-getting-started/guillimin-matlab
%

file = fullfile(path, 'moab.m');
fid = fopen(file, 'w');


fprintf(fid, 'function [nodes,ppn,time] = moab()\n');
fprintf(fid, '%% Generated by set_moab_file.m\n\n');
fprintf(fid, 'nodes = %i;\n\nppn = %i;\n\ntime = ''%s'';\n\nend', n_nodes, ppn, wall_time);

fclose(fid);

end

