function [ data_struct ] = make_ft_data_struct ( ts, data_trials, label )
%UNTITLED Creates a FieldTrip data structure from a simulation output
%  

if ~exist('label','var')
   label = 'Channel '; 
end

N_trial = length(data_trials);
trial = cell(1, N_trial);
time  = cell(1, N_trial);

for tr = 1 : N_trial

    data = data_trials{tr};
    
    N_t = size(data,1);
    N_s = size(data,2);

    time{tr} = ts';
    trial{tr} = data';

end

cfg = [];
cfg.ntrials = N_trial;
cfg.fsample = N_t / max(ts);     % Sampling rate in s^-1
%cfg.method = 'raw';
cfg.nsignal = N_s;
cfg.triallength = max(ts);

% create the output data
data_struct         = [];
data_struct.trial   = trial;
data_struct.time    = time;
data_struct.fsample = cfg.fsample;
data_struct.label   = cell(1,N_s);
for i = 1 : N_s
    data_struct.label{i} = sprintf('%s %i', label, i);
end
data_struct.cfg     = cfg;

end

