function [ results ] = compute_partial_coherence( params, results, triplets )
%COMPUTE_PARTIAL_COHERENCE Computes partial wavelet coherence from the given results
%   
% params              - Parameters used to generate results
% results             - Output from a set of simulations
% models              - The corresponding models
% triplets            - List of three-edge combinations of the form [e1,e2,e3],
%                       where partial coherence will be computed for e1,e2
%                       after removing the influence of e3
%
% 
% results             - Same as input argument results,, with an added field pcoh, 
%                       containing time-varying partial coherence for each triplet

N_pc = size(triplets,1);
N_itr = params.n_trials * params.n_delays * params.n_probs * params.n_weights;
ts = zeros(N_pc, N_itr, 3, params.sim_options.t_stop);
itr = 1;
results2 = cell(N_itr, N_pc); 

for i = 1 : params.n_trials
    for p = 1 : params.n_probs
        for j = 1 : params.n_delays
            for k = 1 : params.n_weights
                result = results(i,p,j,k);
                for t = 1 : N_pc
                    triplet = triplets(t);
                    ts(t,itr, 1, :) = result.E(:,triplet(1));
                    ts(t,itr, 2, :) = result.E(:,tN_mriplet(2));
                    ts(t,itr, 3, :) = result.E(:,triplet(3));
                end
                itr = itr + 1;
            end
        end 
    end
end

% Analyze in parallel

parfor i = 1 : N_itr
    
    for c = 1 : N_pc
        y = squeeze(ts(c,i,1,:));
        x1 = squeeze(ts(c,i,2,:));
        x2 = squeeze(ts(c,i,3,:));
        
        result = get_result();
        [result.Rsq,result.period,result.scale,result.coi,result.wtcsig] = pwc_nofig(y,x1,x2);
        
        results2(i,c) = {result};
    end
end

itr = 1;
for i = 1 : params.n_trials
    for p = 1 : params.n_probs
        for j = 1 : params.n_delays
            for k = 1 : params.n_weights
                result_old = results(i,p,j,k);
                for t = 1 : N_pc
                    result_new = results2(itr,t);
                    result_old.pcoh(t) = result_new;
                end
                results(i,p,j,k) = result_old;
                it = it + 1;
            end
        end 
    end
end


end

function [ result ] = get_result

result.Rsq=[];
result.period=[];
result.scale=[];
result.coi=[];
result.wtcsig=[];

end
