function [  ] = mgui_write_polygons ( polygons, file_name )
%mgui_write_polygons Writes polygons to a format readable by ModelGUI
%   
% polygons - A cell array of N_i X 3 coordinates, each cell defining a
%            polygon as an ordered list of coordinates OR a single polygon
%

if ~iscell(polygons)
    polygons = {polygons};
end

fid = fopen(file_name, 'w');
if (fid == -1)
   error( 'Could not open file for writing: %s', file_name );
end

n_poly = length(polygons);
fprintf(fid,'%i\n',n_poly);

for i = 1 : n_poly
   polygon = polygons{i}; 
   n_vert = size(polygon,1);
   fprintf(fid,'\n%i\n',n_vert);
   
   for j = 1 : n_vert
       fprintf(fid,'%1.6f %1.6f %1.6f\n',polygon(j,1),polygon(j,2),polygon(j,3));
   end
    
end

fclose(fid);

end

