function [ mapped ] = map_values_onto_atlas ( atlas_idx, atlas_list, values )

% Maps ROI-associated values onto vertices/voxels, given an atlas
%
% PARAMETERS:
%
% atlas_idx (N x 1)        Vertex-wise atlas indices, where N = # vertices
% atlas_list (R x 1)       List of atlas indices, where R = # ROIs
% values (R x 1)           Values to map onto atlas
%
% OUTPUT:
%
% mapped (N x 1)           Mapped values
%

N = length(atlas_idx);
R = length(atlas_list);
mapped = zeros(N,1);

for i = 1 : R
   
    idx = atlas_list(i);
    idx_match = atlas_idx == idx;
    
    mapped(idx_match) = values(i);
    
end