function [ roi_map ] = map_between_atlases ( rois_in, idx_in, rois_int, idx_int )

% Maps rois_in to rois_int by finding the ROI in rois_int which maximally
% overlaps each ROI in rois_in
%
% PARAMETERS
%
% rois_in           N x 1 vertex-wise ROI assignments
% rois_int          N x 1 target vertex-wise ROI assignments
%
% RETURNS       
%
% roi_map           R x 1 mapped ROIs from rois_int, where R = # ROIs in
%                   rois_in


if ~exist('roi_idx','var')
    idx_int = unique(rois_int);
end
R = length (idx_in);
R2 = length (idx_int);
roi_map = -ones(R,1);

for i = 1 : R
    
    roi = idx_in(i);
    intersect = rois_int(rois_in == roi);
    
    counts = zeros(R2,1);
    for j = 1 : R2
        counts(j) = sum(intersect == idx_int(j));
    end
    
    [~,k] = max(counts);
    roi_map(i) = idx_int(k);
    
end
