function [ M ] = make_matrix_symmetric( M, op )
%MAKE_MATRIX_SYMMETRIC Makes a matrix symmetric bby applying op to each
%                      [i,j], [j,i] pair
%   op      One of 'max' (default), 'min', 'sum', 'prod'
%
% NB: Assumes M is square 
%
% Author: Andrew Reid, MNI, 2012

if ~exist('op','var'), op = 'max'; end

N = size ( M, 1 );
for i = 1 : N
    for j = i + 1 : N
        val1 = M(i,j);
        val2 = M(j,i);

        if strcmp(op, 'max')
            val3 = max (val1,val2);
        elseif strcmp(op, 'min')
            val3 = min (val1,val2);
        elseif strcmp(op, 'sum')
            val3 = val1 + val2;
        elseif strcmp(op, 'prod')
            val3 = val1 * val2;
        end

        M(i,j) = val3;
        M(j,i) = val3;
    end
    
end

