function [ Y ] = load_civet_data( civet_dir, subjects, prefix, suffix, hemi, subdir, ext )
%LOAD_CIVET_DATA Loads vertex-wise thickness data from a Civet output 
%                directory, for a list of subjects
%   
% PARAMETERS:
% 
% civet_dir         The Civet output directory
% subjects          A list of subject ids corresponding to subject
%                   directories in civet_dir; pass an empty array [] to
%                   process all available subjects
% prefix            The prefix for the data files (part preceding the
%                   subject id in the filename); do not include the
%                   underscore
% suffix            The prefix for the data files (part following the
%                   subject id and preceding the '_left' or '_right' in the 
%                   filename) 
% hemi              Hemisphere; one of 'left', 'right', 'both' (default)
% subdir            Data subdirectory; default is 'thickness' 
% ext               File extension (include dot); default is '.txt'
%
% AUTHOR: Andrew Reid, BIC, MNI 2011
%
% Build names

M = 1;

if nargin < 3
    prefix=[];
end

if nargin < 4
    suffix=[];
end

if nargin < 5
    hemi = 'both';
end

if strcmp(hemi,'both')
   M = 2; 
end

if nargin < 6
    subdir = 'thickness';
end

if nargin < 7
    ext = '.txt';
end

if isempty(subjects)
   files=dir(civet_dir);
   subjects=cell(length(files)-2,1);
   for i = 3 : length(files)
      if files(i).isdir
         subjects(i-2)={files(i).name}; 
      end
   end
end



N = length(subjects);
civet_dirs = repmat({civet_dir}, N, 1);
underscores = repmat({'_'}, N, 1);
fileseps = repmat({filesep}, N, 1);
%prefixes = repmat({prefix}, N, 1);
%suffixes = repmat({suffix}, N, 1);
subdirs = repmat({subdir}, N, 1);
exts = repmat({ext}, N, 1);

if ~isempty(prefix)
    prefixes = strcat(repmat({prefix}, N, 1), underscores);
else
    prefixes = repmat({''}, N, 1);
end

if ~isempty(suffix)
    if ~strcmp(hemi, 'none')
        suffixes = strcat(repmat({suffix}, N, 1), underscores);
    else
        suffixes = repmat({suffix}, N, 1);
    end
else
    suffixes = repmat({''}, N, 1);
end

filenames=cell(N,M);
i = 1;

if strcmp(hemi, 'left') || strcmp(hemi, 'both')
   
    lefts=repmat({'left'}, N, 1);
    filenames(:,i) = strcat(civet_dirs, fileseps, subjects, fileseps, subdirs, ...
                          fileseps, prefixes, subjects, underscores, ...
                          suffixes, lefts, exts);
    i = i + 1;                      
    
end

if strcmp(hemi, 'right') || strcmp(hemi, 'both')
   
    rights=repmat({'right'}, N, 1);
    filenames(:,i) = strcat(civet_dirs, fileseps, subjects, fileseps, subdirs, ...
                          fileseps, prefixes, subjects, underscores, ...
                          suffixes, rights, exts);
                          
end

if strcmp(hemi, 'none')
    filenames(:,i) = strcat(civet_dirs, fileseps, subjects, fileseps, subdirs, ...
                          fileseps, prefixes, subjects, underscores, ...
                          suffixes, exts);
end

Y = SurfStatReadData(filenames);

end

