function [ v, t ] = integrate_tseries2 ( t, v, window )
%INTEGRATE_TSERIES Integrates v wrt. t, at each time point, with the
%                  specified window size (in time units)
%   

N_t = length(t);
dt = t(end) / N_t;
% 
widx = round(window * dt);
% widx = 2*floor(widx/2)+1;

N_new = floor( N_t / widx );
cull = (N_t / widx) - N_new;
cull_start = floor(cull / 2);
cull_end = ceil(cull) - cull_start;

v2 = zeros(N_new, size(v,2));
t2 = zeros(N_new, 1);

j = 1;
for i = 1 + cull_start : widx : N_t - cull_end;
   
    wdw = i : i + widx - 1;
    t_i = t(wdw);
    v_i = v(wdw,:);
    
    v2(j,:) = trapz(t_i,v_i);
    t2(j) = t(wdw(end/2));
    
    j = j + 1;
end

v = v2 / window;
t = t2;

end

