function [ v, t ] = integrate_tseries ( t, v, window )
%INTEGRATE_TSERIES Integrates v wrt. t, at each time point, with the
%                  specified window size (in time units)
%   

N_t = length(t);
dt = t(end) / N_t;

widx = round(window * dt);
widx = 2*floor(widx/2)+1;

cull = floor(widx/2);
v2 = zeros(N_t - cull * 2, size(v,2));

j = 1;
for i = 1 : N_t - widx + 1
   
    wdw = i : i + widx - 1;
    t_i = t(wdw);
    v_i = v(wdw,:);
    
    v2(j,:) = trapz(t_i,v_i);
    j = j + 1;
end

v = v2 / window;
t = t(cull+1:end-cull);

end

