%% Program for 
% 1. finding the mean thickness for AAL ROIs from 81,924 vertices 
% 2. finding the residuals after correcting for age, gender, IQ etc.
% 3. finding the Correlation Matrix from the residuals


clear ;
clc ;

load('/home/francois/Documents/GOBS_scripts/budha_matlab/ordered_AAL.mat'); % Path to atlas partition
rois_file    = ('/home/francois/Documents/GOBS_scripts/budha_matlab/aal_both_rsl_final.txt');
rois         = SurfStatReadData(rois_file);


load ('/home/francois/data/surfstat_budha/avsurf/avsurf.mat') ;
load ('/home/francois/data/surfstat_budha/avsurf/mask.mat') ;
load('/home/francois/data/gobs/demographic_data/clean/gobs_thickness_proj1.mat'); % load thickness data for both hemispheres
load('/home/francois/data/gobs/demographic_data/clean/gobs_demographics_proj1.mat') % Load data on covariates
Y = gobs_thickness; % assign data to Y
mask = mask';
%%

n_rois  = 90; n_roism = 78 ;
% figure; SurfStatView( rois, avsurf, 'Cortical Thickness Parcellation (AAL)' ) ;

[n_scans, n_nodes] = size(Y) ;         %n_scans = n_subjects %Y = Thick; Y1 = Thick_residual, Y = thickness data
   
%For 90 ROIs (including Sub-cortical)
VRoi = zeros(n_scans,n_rois) ;
for i=1:n_scans
    for j=1:n_rois
        roi = (rois>(j-0.5))&(rois<(j+0.5));
        VRoi(i,j) = sum(Y(i,:).*roi)/sum(roi);
    end
end
%%
%For 78 ROIs (excluding Sub-cortical)
VRoi_2 = zeros(n_scans, n_roism) ;
for i=1:n_scans
    for j=1:n_roism
        VRoi_2(i,j) = VRoi(i,AAL_Label_number(j)) ;
    end
end

meanthicksubj = mean(double(Y(:,mask)),2) ;
%% Define covariates

age = str2double(gobs_demographics(:,3));
age_2 = (age-mean(age)).^2;
age_3 = (age-mean(age)).^3;
gender = cell2mat(gobs_demographics(:,4));
mean_thickness = mean(double(Y(:,mask)),2);

%% Finding Residuals from Linear Model
Age = term(age) ;
Age_2 = term(age_2) ;
Age_3 = term(age_3) ;
Gender = term(gender);
Global = term(mean_thickness);

M = 1 + Global ;% + Age + Age_2 + Gender ;%+ Global;
% M = 1 + Age + Gender + Meanthicksubj + random(Subj) + I ;   

slm = [] ;
slm = SurfStatLinMod(VRoi_2, M) ;
VRoi_residual = VRoi_2 - slm.X*slm.coef;

%% Normality tests on cortical thickness for each ROI
% for i = 1:size(VRoi_residual,2)
%     rand_sample = randn(100000,1);
%     rand_sample = rand_sample*std(VRoi_residual(:,i));
%     rand_sample = rand_sample+mean(VRoi_residual(:,i));
%     [h,p] = kstest2(VRoi_residual(:,i),rand_sample,0.05);
%     normality_test(i,1) = double(h);
%     normality_test(i,2) = p;
% end
% 
% if ~isempty(find(normality_test(:,1)));
%     warning('Data in the following ROIs is not normally distributed')
%     find(normality_test(:,1))
% end

%% Finding Correlation Matrix
n_roism = 78;
[cm,p] = corrcoef(VRoi_residual) ;
cm = cm - eye(n_roism,n_roism) ;

%imagesc(cm, [-0.7, 0.8]), colorbar
figure; imagesc(cm, [-1, 1]),  colorbar


%% Thresholding Correlation Matrix after correcting for FDR
[pID pN] = fmri_FDR_ni(p,0.05) ;

CM_thres_pID = zeros(n_roism,n_roism) ;

for i=1:n_roism;
    for j=1:n_roism;
        if p(i,j) > 0
           if p(i,j) < pN
              CM_thres_pID(i,j) = cm(i,j) ;
           end
        end
    end
end
figure; imagesc(CM_thres_pID, [-1, 1]), colorbar
% set(gca,'YTick',1:78)
% set(gca,'YTickLabels',AAL_descript)   normality test = [h,p] = jbtest(...) 

%% hierarchical clustering and stability analysis on thickness data
list_sc = 9;
sil = zeros(length(list_sc),1);
num_e = 1;
for num_sc = list_sc
    niak_progress(num_sc,length(list_sc))
    psom_set_rand_seed(num_sc);
    nb_samps = 100; % the number of samples
    nb_subj = size(VRoi_residual,1); % the number of subjects
    nb_atoms = size(VRoi_residual,2); % the number of atoms
    opt_t.thresh = num_sc; % the number of clusters
    opt_c.flag_verbose = false; % shut up verbose for hierarchical clustering
    stab = zeros(nb_atoms,nb_atoms); % initialize the stability matrix
    for num_s = 1:nb_samps
        ind_subj = randperm(nb_subj); % random permutation of subjects
        ind_subj = ind_subj(1:floor(0.6*nb_subj)); % keep only 60% of subjects
        samp_roi = VRoi_residual(ind_subj,:); % extract data for the subsample
        samp_roi = samp_roi - repmat(mean(samp_roi,2),[1 size(samp_roi,2)]); % normalize for global average
        R = niak_build_correlation(samp_roi); % build correlation matrix between cortical thickness measures
        hier = niak_hierarchical_clustering(R,opt_c); % hierarchical clustering
        part = niak_threshold_hierarchy(hier,opt_t); % get a partition into K clusters based on the hierarchy
        part_adj = niak_part2mat(part,true); % represent the clusters as an adjacency matrix
        stab = stab + part_adj; % accumulate stability values
    end
    stab = stab / nb_samps; % the stability matrix
    hier_c = niak_hierarchical_clustering(stab,opt_c); % the consensus clustering
    part_c = niak_threshold_hierarchy(hier_c,opt_t); % the consensus partition
    sil(num_e) = mean(niak_build_silhouette(stab,part_c,false));
    num_e = num_e+1;
end

figure
plot(list_sc,sil);

%% Visualize the results of the stability analysis
order = niak_hier2order(hier_c);

opt.limits = [-1 1];
figure
niak_visu_matrix(CM_thres_pID(order,order),opt);

figure
niak_visu_matrix(stab(order,order));
title('Stability matrix');
figure
niak_visu_part(part_c(order))
title('Consensus partition');

% Build a surface representation of AAL regions
atoms = zeros(size(rois));
for num_a = 1:length(AAL_Label_number)
    atoms(rois==AAL_Label_number(num_a))=num_a;
end

% Visualize the consensus partition
figure
partsurf = niak_part2vol(part_c,atoms); % generate a surface representation of the consensus partition
niak_visu_surf(partsurf,avsurf);
    
%% Visualize stability map
figure
opt_v.limit = [0 1];
stab_map = mean(stab(:,part_c==7),2); % Build stability map at the atom level
stab_surf = niak_part2vol(stab_map,atoms); % surface representation of the stability map
niak_visu_surf(stab_surf,avsurf,opt_v)

%% build network-level thickness
net_thick = zeros(nb_subj,opt_t.thresh);
for num_c = 1:opt_t.thresh
    net_thick(:,num_c) = mean(VRoi_residual(:,part_c==num_c),2);
end

Rthick = niak_build_correlation(net_thick);

figure
niak_visu_matrix(Rthick);
% net_thick_n = net_thick - repmat(mean(VRoi_2,2),[1 size(Rthick,2)]); % normalized average thickness

%% Heritability figures
% 
% heritability_raw = niak_read_csv('/home/francois/Documents/Paper_struc_covariance/SOLAR_herit_AAL_withmean.csv');
% herit_part = heritability_raw(:,5);
% herit_surf = niak_part2vol(herit_part,atoms);
% figure
% niak_visu_surf(herit_surf,avsurf);