function [ top ] = get_top (matrix, method)

% Returns the top diagonal of this matrix. If the matrix has three
% dimensions, the first two must be square.
%
% method - which of top, bottom, or merge_(mean, max, min, sum) to use;
%          default is top
%

if nargin < 2
   method = 'top'; 
end

    N = size (matrix,1);
    S = size (matrix,3);
    M = (N * (N - 1)) / 2;
    top = zeros(M,S);

    k = 1;
    for i = 1:N
        for j=i+1:N
            if strcmp(method, 'top')
                top(k,:) = matrix(i,j,:);
            elseif strcmp(method, 'bottom')
                top(k,:) = matrix(j,i,:);
            elseif strcmp(method, 'merge_mean')
                top(k,:) = (matrix(i,j,:) + matrix(j,i,:)) / 2;
            elseif strcmp(method, 'merge_max')
                top(k,:) = max(matrix(i,j,:),matrix(j,i,:));
            elseif strcmp(method, 'merge_min')
                top(k,:) = min(matrix(i,j,:),matrix(j,i,:));
            elseif strcmp(method, 'merge_sum')
                top(k,:) = matrix(i,j,:) + matrix(j,i,:);
            end
            k = k + 1;
        end
    end

end