function [ area ] = get_surface_area( surf, mask )
%GET_SURFACE_AREA Computes the surface area of a surface mesh (SurfStat format)
%   
% surf          The SurfStat mesh
% mask          [Optional] Specifies a subset of vertices for which to compute the
%                          surface area

if exist('meshSurfaceArea') ~= 2
   error('This function requires the geom3d library. Please ensure it is present and on the path.');
end

if nargin == 1
   area = meshSurfaceArea(surf.coord', surf.tri);
   return;
end

surf = get_submesh(surf,mask);
area = get_surface_area(surf);

end

