function [ submesh ] = get_submesh( surf_mesh, mask )
%GET_SUBMESH Returns a submesh of surf_mesh, containing only vertices in mask
%   

faces = surf_mesh.tri;
N_vert = length(mask);

%h = waitbar(0,'Computing submesh...');

idx_mask = find(mask);
face_mask = ismember(faces,idx_mask);
face_mask = sum(face_mask,2) == 3;
new_faces = faces(face_mask,:);
faces = new_faces;

for i = 1 : N_vert
    % For each vertex, 
    %   - if it is not in the mask, 
    %      - remove faces containing it
    %      - subtract one from all remaining indices > i
    
    if ~mask(i)
       idx = find(faces>i);
       if ~isempty(idx)
         new_faces(idx) = new_faces(idx)-1;
       end
    end
    
    %waitbar(i/N_vert,h,sprintf('%1.1f%% along...',i/N_vert*100))
    
end

submesh.coord = surf_mesh.coord(:,logical(mask));
submesh.tri = new_faces;

end

