function [ R, P, R2, CORR ] = get_subject_partial_linear_models ( PC, X, thres )

% Compute linear models for each top element of PC (M x M x N) on the 
% matrix of factors X (N x P)

if nargin < 3
   thres = 0.05; 
end

M=size(PC,1);
N=size(PC,3);
model = [ones(N,1) X];
R=zeros(M,M);
P=zeros(M,M);
R2=zeros(M,M);
CORR=zeros(M,M);

for i = 1 : M
    for j = i + 1 : M
        PCij = squeeze(PC(i,j,:));
        [b,bint,r,rint,stats] = regress(PCij,model);
        corr = corrcoef(PCij,X);
        p = stats(3);
        if ~isnan(p)
            CORR(i,j)=corr(1,2);
            CORR(j,i)=corr(1,2);
            P(i,j)=p;
            P(j,i)=p;
            r2 = stats(1);
            R2(i,j)=r2;
            R2(j,i)=r2;
            if p < thres
                R(i,j) = b(2);
                R(j,i) = b(2);
            end
        end
    end
end

