function [ G V I ] = get_sorted_groups( M, n )
%
% Breaks M into n groups, sorted in ascending order
% 
% V - The values as one vector
% G - The groups as one vector
% I - The indices as one vector
%

N = length(M);
[M_sort ind] = sort(M);

size = ceil(N / n);

G = cell(N,1);
V = zeros(N,1);
I = zeros(N,1);

s = 1;

for i = 1 : n - 1
   
    group = strcat('s',num2str(i));
    values = M_sort(s : s + size);
    indices = ind(s : s + size);
    V(s : s + size) = values;
    G(s : s + size) = mat2cell(group);
    I(s : s + size) = indices;
    s = s + size;
    
end

group = strcat('s',num2str(n));
values = M_sort(s : end);
indices = ind(s : end);
V(s : end) = values;
G(s : end) = mat2cell(group);
I(s : end) = indices;
