function [ areas ] = get_roi_surface_areas( surf, roi_labels, roi_list, roi_names )
%GET_ROI_SURFACE_AREAS Returns a vector of surface areas computed for a 
% list of ROIs
%   
% surf         SurfStat format surface
% roi_labels   N_vert x 1 vector of ROI indices
% roi_list     List of indices for which to compute areas; if not specified, 
%              all unique values are use
%

if nargin < 3
   roi_list = unique(roi_labels); 
end

N_roi = length(roi_list);
areas = zeros(N_roi,1);

for i = 1 : N_roi
   idx = roi_list(i);
   mask = roi_labels == idx;
   if sum(mask) > 0
      areas(i) = get_surface_area(surf, mask);
   end
   if exist('roi_names','var')
        fprintf('\nArea for ROI %s: %1.3f', roi_names{i}, areas(i));
   else
       
   end
end


end

