function [ G ] = get_regular_graph( N, K )
%GET_REGULAR_GRAPH Constructs a regular binary graph with N vertices and K 
%                  edges per vertex (as per Watts & Strogatz model).
%   

G = zeros(N);

% For each vertex, connect its K closest neighbours

a = floor(K/2);
b = ceil(K/2);

for i = 1 : N
    for j = i - a : i + b
        j2 = j;
        if j2 < 1
           j2 = j + N; 
        end
        if (j2 > N)
           j2 = j2 - N; 
        end
        if (i ~= j2)
           G(i,j2) = 1;
        end
    end
end

end

