function [ products ] = get_regional_products ( y_regions )

% Computes products between each pair of roi-wise data, for each instance
% of the data.
%
% PARAMETERS
%
% y_regions     N x R matrix of data, where N = # instances (subjects) and
%               R = # rois
%
% OUTPUT
%
% products      R x R x N matrix of products, where each R x R matrix is
%               symmetric
%
%

N = size (y_regions, 1);
R = size (y_regions, 2);

products = zeros (R, R, N);

for i = 1 : R
   for j = i + 1 : R 
        y1 = y_regions(:,i);
        y2 = y_regions(:,j);
        prod = y1.*y2;
        products(i,j,:) = prod;
        products(j,i,:) = prod;
   end
end


