function [regional_means] = get_regional_means(Y, labels, label_list);

%% 
% get_regional_means(Y, labels, label_list)
%
% Computes a mean for each ROI in label_list (an R-by-1 vector of integer 
% label ids) from labels (an N-by-1 vector of labels) and Y (an N-by-M 
% vector of values).
%
% Returns: regional_means, an M-by-R matrix of mean values
%
% Author: Andrew Reid, BIC, MNI 2011
%
% 

M = size(Y,2);
R = length(label_list);
regional_means = nan(M,R);

for i = 1:R
    label=label_list(i);
    region_ct = Y(labels == label,:);
     if (size(region_ct,1)==0)
         fprintf('Warning: Region %i (index %i) has no values; set to NaN!\n',i,label);
     else
        for j = 1:M
            regional_means(j,i) = sum(region_ct(:,j))/size(region_ct,1);
        end
     end
end
