function [ centroids ] = get_regional_centroids ( surf, atlas_labels, atlas_list )

% Computes centroids for a list of atlas regions defined on a surface
% mesh.
%
%
%

N = length (atlas_list);
centroids = zeros(N,3);

for i = 1 : N
   
    idx = atlas_list(i);
    coords = surf.coord(:,atlas_labels==idx);
    centroids(i,:) = mean(coords,2);
    
end