function [ rates, ids, tids ] = get_rates ( id, tid, x, y )

% Compute rates from repeated measures
%
%
%
%

uid = unique(id);
k = 1;

for i = 1 : length(uid)
   
    id_i = uid(i);
    T = strcmp(id, id_i);
    x_i = x(T);
    
    if length(x_i) > 1

        [x_i, idx] = sort(x_i);
        y_i = y(T,:);
        y_i = y_i(idx,:);
        tid_i = tid(T);
        tid_i = tid_i(idx);

        for j = 1 : length(x_i) - 1
            yy = (y_i(j+1,:) - y_i(j,:));
            xx = (x_i(j+1) - x_i(j));
            rates(k,:) = yy / xx;
            tids(k,1) = tid_i(j);
            tids(k,2) = tid_i(j+1);
            ids(k,1) = id_i;
            k = k + 1;
        end
    end
    
end