function [ error ] = get_prediction_error ( x, y, b )

% Computes the prediction error for x (an n x p matrix of covariates) and
% y (an n x 1 vector of observations), from the regression model specified
% by b (a (n + 1) x 1 vector of beta values, produced by the regress function
% of Matlab). Assumes b(1) is the constant term.
%
% error - The prediction error, computed as y - y_hat.
%

n = length(y);
p = length(b);
error = zeros(n,1);

for i = 1 : n
    
    y_i = y(i);
    x_i = x(i,:)';
    
    % Multiply betas by x rows
    y_hat = zeros(p,1);
    y_hat(1) = b(1);
    
    for j = 2 : p
        el = x_i(j).*b(j);
        y_hat(j) = el;
    end
    
    error(i) = y_i - sum(y_hat);
end

end
