function [ dist ] = get_euclidean_distance ( roi_centroids )
%get_euclidean_distance Return Euclidean distance between each pair
%                       of ROIs
%
% INPUT
%
% roi_centroids         N x 3 vector of coordinates
%

N = size(roi_centroids,1);
dist = zeros(N);

for i = 1 : N
   for j = i + 1 : N
       p_i = roi_centroids(i,:);
       p_j = roi_centroids(j,:);
       dist(i,j) = sqrt((p_i(1) - p_j(1))^2 + (p_i(2) - p_j(2))^2 + (p_i(3) - p_j(3))^2);
       dist(j,i) = dist(i,j);
   end
end

end

