function [ result ] = get_discriminant ( X, groups, group_list )

% Compute a linear discriminant based on the relation x'(R1^-1 - R2^-1),
% where R1 and R2 are the covariance matrices derived from the groups
% argument.
%
% PARAMETERS:
%
% X             N x S matrix of discriminant data; N is # subjects, S is #
%               observations per subject
% groups        List of group assignments, as cell strings
% group_list    Groups to discriminate
%

X1 = X(strcmp(groups,group_list(1)),:);
X2 = X(strcmp(groups,group_list(2)),:);

R1 = get_correlation_matrix2(X1,0.05,true,false);
R2 = get_correlation_matrix2(X2,0.05,true,false);

R1_inv = inv(R1);
R2_inv = inv(R2);

result = R1_inv - R2_inv;