function [ C, P, sensitivity, specificity ] = get_confusion_matrix ( data, predicted )

%
% GET_CONFUSION_MATRIX returns a confusion matrix from two data vectors
%
% PARAMETERS:
%
% data          The actual data
% predicted     The predicted data
%
% RETURNS 
% 
% C         A confusion matrix with rows corresponding to actual classes
%           and columns to predicted class; values are frequencies.
% P         The proportion of total items
%
% AUTHOR: Andrew Reid, MNI, 2012
% 

classes = unique(data);

nc = numel(classes);

C=zeros(nc);
P=zeros(nc);

tp=0;
fp=0;
tn=0;
fn=0;

N=numel(data);

for i = 1 : nc
   
    c = classes(i);
    data_i = (data==c);
    pred_i = predicted(data_i);
    n = sum(data_i);
    
    for j = 1 : nc
        C(i,j) = sum(pred_i==j);
        P(i,j) = C(i,j) / n;
        if i==j
           tp=tp+C(i,j);
           fn=fn+(N-tp);
        else
           fp=fp+C(i,j);
           tn=tn+(N-fp);
        end
    end
    
end

sensitivity=tp/(tp+fp);
specificity=tn/(tn+fn);

