function [ results ] = get_bootstrap_integrals ( results, params, group_list )

j = 0;
s = params.sp_min;
int_s = -1;
int_e = -1;
while s <= params.sp_max
    j = j + 1;
    if s >= params.int_start && int_s < 0
       int_s = j; 
    end
    if s > params.int_end && int_e < 0
       int_s = j - 1; 
    end
    s = s + params.sp_step;
end

params.sp_count = j;

if int_e < 0
   int_e = params.sp_count; 
end

for g = 1 : length(group_list);
    group = cell2mat(group_list(g));

    results.(group).integral_global = zeros(params.boot_n,1);
    results.(group).integral_local = zeros(params.boot_n,1);

    % Denominator for normalization of integral
    int_delta = params.int_end - params.int_start;

    for j = 1 : params.boot_n
       slm1 = slmengine(results.sparsities(int_s:int_e),results.(group).global_E(int_s:int_e,j),'knots',100,'plot','off') ;
       results.(group).integral_global(j) = slmpar(slm1,'integral', [params.int_start,params.int_end]) / int_delta;
       slm1 = slmengine(results.sparsities(int_s:int_e),results.(group).local_E(int_s:int_e,j),'knots',100,'plot','off') ;
       results.(group).integral_local(j) = slmpar(slm1,'integral', [params.int_start,params.int_end]) / int_delta;
    end

end