function [ Y_filtered, filter_idx ] = filter_values_by_values( Y, all_values, values )
%FILTER_THICKNESS_BY_SUBJECT Filters Y for the desired set of values
%   

n = size(Y,1);
n2 = length(all_values);

s = numel(values);
if (iscell(Y))
    Y_filtered = cell(n,s);
else
    Y_filtered = NaN(n,s);
end

filter_idx = false(n2,1);
for i = 1 : s
    
    subj=values(i);
    index = find(all_values == subj);
    filter_idx(index)=true;
    if (numel(index)>0)
        Y_filtered(:,i)=Y(:,index(1)); 
    else
        warning(['Value ', num2str(subj), ' not in list! @index ', num2str(i)]);
    end
    
end

end

