function [ results ] = evaluate_cost_model( N, M, B )
%EVALUATE_COST_MODEL Computes weighted efficiency values for a network of 
%                    size N with wiring costs varying from zero to one with 
%                    M steps, simulated by randomly assigning new edges and 
%                    edge weights. After Latora & Marchiori (2002), Model 2.
%
% PARAMETERS:
%
%   N          Size of the network (vertex count)
%   M          Total steps (including zero and one)
%   B          Number of bootstrap samples 
%

results.cost = zeros(M,1);
results.e_global = zeros(B,M,1);
results.e_local = zeros(B,M,1);

for b = 1 : B

i=1;

    for p = 0 : 1 / (M - 1) : 1

        network = rand(N);
        network = network.*double(network < p);

        eff = compute_weighted_efficiency( network, 0, 10 );
        if i == 1
            results.cost(i) = p;
        end
        results.e_global(b,i) = eff.e_global;
        results.e_local(b,i) = eff.e_local;

        i = i + 1;

    end

end

results.mean_e_global = mean(results.e_global,1);
results.mean_e_local = mean(results.e_local,1);

end

