function [ groups_eq, idx_eq ] = equalize_groups( groups )
%EQUALIZE_GROUPS Equalizes the number of subjects per group, n_min
%                by randomly selecting from all groups n_min times.

ugrp=unique(groups);
M = numel(ugrp);
n_min=1e10;  % arbitrarily large

% Determine n_min
for i = 1 : M
    grp = ugrp(i);
    if iscell(groups)
        i_grp=find(strcmp(groups,grp));
    else
        i_grp=find(groups==grp);
    end
    n_i = numel(i_grp);
    if n_i < n_min, n_min = n_i; end;
end

idx_eq=zeros(M * n_min,1);

for i = 1 : M
    grp = ugrp(i);
    if iscell(groups)
        i_grp=find(strcmp(groups,grp));
    else
        i_grp=find(groups==grp);
    end
    n_i = numel(i_grp);
    idx=((i-1)*n_min) + 1;

    if n_i > n_min
        new_i_grp=randsample(i_grp,n_min);
        idx_eq(idx:idx+n_min-1)=new_i_grp;
    else
        idx_eq(idx:idx+n_min-1)=i_grp;
    end

end

idx_eq=sort(idx_eq);
groups_eq=groups(idx_eq);

end

