function [ C ] = dir2undir( C, method )

%DIR2UNIDIR Makes a directed network undirected
%
% C     - An N x N adjacency matrix
% both  - either 'sum', 'mean', 'max' (default), or 'min'
%

if nargin < 2
   method = 'max'; 
end
N = size(C,1);

for i = 1 : N - 1
   
    for j = i + 1 : N
    
        val1 = C(i,j);
        val2 = C(j,i);
        
        if strcmp(method, 'sum')
            new_val = val1 + val2;
        elseif strcmp(method, 'mean')
            new_val = (val1 + val2) / 2;
        elseif strcmp(method, 'min')
            new_val = min(val1, val2);
        elseif strcmp(method, 'max')
            new_val = max(val1, val2);
        else
            % Should never get here
            error('Method not specified..');
        end
        
        C(i,j) = new_val;
        C(j,i) = new_val;
        
    end
    
end

