function [ v ] = cwt_tseries( v, scales, wname )
%SMOOTH_TSERIES Applies a continuous wavelet transform to v, at each scale 
%               in scales 
%   

if ~exist('wname','var')
   wname = 'morl'; 
end

N_t = size(v,1);
N_v = size(v,2);
N_s = length(scales);

v2 = zeros(N_t,N_v,N_s);

for i = 1 : N_v
    c = cwt(v(:,i), scales, wname)';
    v2(:,i,:) = c;
end

v = v2;

end

