function [ results ] = corr_net_binary_stats( results, group_list, params, boots );

thr_min = 0.05;
thr_max = 0.4;
thr_step = 0.025;
boot_n = 20;
int_start = 0.1;
int_end = 0.3;
integral_type='trap';

if nargin > 2
    thr_min = params.thr_min;
    thr_max = params.thr_max;
    thr_step = params.thr_step;
    boot_n = params.boot_n;
    int_start = params.int_start;
    int_end = params.int_end;
    integral_type=params.integral_type;
end

int_s = -1;
int_e = -1;
s = thr_min;
j = 0;

while s <= thr_max
    j = j + 1;
    if s >= int_start && int_s < 0
       int_s = j; 
    end
    if s > int_end && int_e < 0
       int_e = j - 1; 
    end
    s = s + thr_step;
end

thr_count = j;

if int_e < 0
   int_e = thr_count; 
end

R=1;

% Efficiency measures integrated
for g = 1 : length(group_list);
    group = cell2mat(group_list(g));
    R = size(results.(group).reg_local_E,3);
    
    % init variables
    results.(group).mean.global_E = zeros(thr_count,1);
    results.(group).std.global_E = zeros(thr_count,1);
    results.(group).mean.local_E = zeros(thr_count,1);
    results.(group).std.local_E = zeros(thr_count,1);
%     results.(group).mean.reg_global_E = zeros(thr_count, boot_n);
%     results.(group).std.reg_global_E = zeros(thr_count, boot_n);
     results.(group).mean.reg_local_E = zeros(thr_count, boot_n);
     results.(group).std.reg_local_E = zeros(thr_count, boot_n);
%     results.(group).mean.deg_centr = zeros(thr_count, boot_n);
%     results.(group).std.deg_centr = zeros(thr_count, boot_n);
%     results.(group).mean.betw_centr = zeros(thr_count, boot_n);
%     results.(group).std.betw_centr = zeros(thr_count, boot_n);
    
    % 1. Group mean and variance
    for i = 1 : thr_count
        results.(group).mean.global_E(i) = mean(results.(group).global_E(i,:));
        results.(group).std.global_E(i) = std(results.(group).global_E(i,:));
        results.(group).mean.local_E(i) = mean(results.(group).local_E(i,:));
        results.(group).std.local_E(i) = std(results.(group).local_E(i,:));
        
         for j = 1 : boot_n
%             results.(group).mean.reg_global_E(i,j) = mean(results.(group).reg_global_E(i,j,:));
%             results.(group).std.reg_global_E(i,j) = std(results.(group).reg_global_E(i,j,:));
             results.(group).mean.reg_local_E(i,j) = mean(results.(group).reg_local_E(i,j,:));
             results.(group).std.reg_local_E(i,j) = std(results.(group).reg_local_E(i,j,:));
%             results.(group).mean.deg_centr(i,j) = mean(results.(group).deg_centr(i,j,:));
%             results.(group).std.deg_centr(i,j) = std(results.(group).deg_centr(i,j,:));
%             results.(group).mean.betw_centr(i,j) = mean(results.(group).betw_centr(i,j,:));
%             results.(group).std.betw_centr(i,j) = std(results.(group).betw_centr(i,j,:));
         end
    end
    
    % 2. Integrals across sparsities
    results.(group).integral_global = zeros(boot_n,1);
    results.(group).integral_local = zeros(boot_n,1);
%     results.(group).integral_reg_global = zeros(boot_n,R);
     results.(group).integral_reg_local = zeros(boot_n,R);
%     results.(group).integral_deg_centr = zeros(boot_n,R);
%     results.(group).integral_betw_centr = zeros(boot_n,R);
    
    % Denominator for normalization of integral
    int_delta=int_end-int_start;
    
    % TODO: Compute integrated regional efficiency
    
    for j = 1 : boot_n
         if strcmp(integral_type, 'fit')
            slm1 = slmengine(results.thresholds(int_s:int_e),results.(group).global_E(int_s:int_e,j),'knots',100,'plot','off') ;
            results.(group).integral_global(j) = slmpar(slm1,'integral', [int_start,int_end]) / int_delta;
            slm1 = slmengine(results.thresholds(int_s:int_e),results.(group).local_E(int_s:int_e,j),'knots',100,'plot','off') ;
            results.(group).integral_local(j) = slmpar(slm1,'integral', [int_start,int_end]) / int_delta;
%             slm1 = slmengine(results.thresholds(int_s:int_e),results.(group).deg_centr(int_s:int_e,j),'knots',100,'plot','off') ;
%             results.(group).integral_deg_centr(j) = slmpar(slm1,'integral', [int_start,int_end]) / int_delta;
%             slm1 = slmengine(results.thresholds(int_s:int_e),results.(group).betw_centr(int_s:int_e,j),'knots',100,'plot','off') ;
%             results.(group).integral_betw_centr(j) = slmpar(slm1,'integral', [int_start,int_end]) / int_delta;
         else 
            results.(group).integral_global(j) = trapz(results.thresholds(int_s:int_e),results.(group).global_E(int_s:int_e,j));
            results.(group).integral_local(j) = trapz(results.thresholds(int_s:int_e),results.(group).local_E(int_s:int_e,j));
            for k = 1 : R
               % results.(group).integral_reg_global(j,k) = trapz(results.thresholds(int_s:int_e),results.(group).reg_global_E(int_s:int_e,j,k));
                results.(group).integral_reg_local(j,k) = trapz(results.thresholds(int_s:int_e),results.(group).reg_local_E(int_s:int_e,j,k));
                %results.(group).integral_deg_centr(j,k) = trapz(results.thresholds(int_s:int_e),results.(group).deg_centr(int_s:int_e,j,k));
                %results.(group).integral_betw_centr(j,k) = trapz(results.thresholds(int_s:int_e),results.(group).betw_centr(int_s:int_e,j,k));
            end
        end
    end
    
    results.(group).mean.integral_global_E = mean(results.(group).integral_global);
    results.(group).mean.integral_local_E = mean(results.(group).integral_local);
%     results.(group).mean.integral_deg_centr = mean(results.(group).integral_deg_centr);
%     results.(group).mean.integral_betw_centr = mean(results.(group).integral_betw_centr);
%     
    results.(group).std.integral_global_E = std(results.(group).integral_global);
    results.(group).std.integral_local_E = std(results.(group).integral_local);
%     results.(group).std.integral_deg_centr = std(results.(group).integral_deg_centr);
%     results.(group).std.integral_betw_centr = std(results.(group).integral_betw_centr);
        
end

% Cost efficiency

for g = 1 : length(group_list);
    group = cell2mat(group_list(g));
    
    % Get cost efficiency values
    cost = results.(group).costs;
    reg_cost = results.(group).reg_costs;
    results.(group).global_costE = results.(group).global_E - cost;
    results.(group).local_costE = results.(group).local_E - cost;
     for k = 1 : R
%         results.(group).reg_global_costE(:,:,k) = results.(group).reg_global_E(:,:,k) - reg_cost(R);
         results.(group).reg_local_costE(:,:,k) = results.(group).reg_local_E(:,:,k) - reg_cost(R);
     end
    
    results.(group).mean.global_costE = zeros(thr_count,1);
    results.(group).std.global_costE = zeros(thr_count,1);
    results.(group).mean.local_costE = zeros(thr_count,1);
    results.(group).std.local_costE = zeros(thr_count,1);
%     results.(group).mean.reg_global_costE = zeros(thr_count, boot_n);
%     results.(group).std.reg_global_costE = zeros(thr_count, boot_n);
     results.(group).mean.reg_local_costE = zeros(thr_count, boot_n);
     results.(group).std.reg_local_costE = zeros(thr_count, boot_n);
    
    % 1. Group mean and variance
    for i = 1 : thr_count
        results.(group).mean.global_costE(i) = mean(results.(group).global_costE(i,:));
        results.(group).std.global_costE(i) = std(results.(group).global_costE(i,:));
        results.(group).mean.local_costE(i) = mean(results.(group).local_costE(i,:));
        results.(group).std.local_costE(i) = std(results.(group).local_costE(i,:));
        
         for j = 1 : boot_n
%             results.(group).mean.reg_global_costE(i,j) = mean(results.(group).reg_global_costE(i,j,:));
%             results.(group).std.reg_global_costE(i,j) = std(results.(group).reg_global_costE(i,j,:));
             results.(group).mean.reg_local_costE(i,j) = mean(results.(group).reg_local_costE(i,j,:));
             results.(group).std.reg_local_costE(i,j) = std(results.(group).reg_local_costE(i,j,:));
         end
    end
   
    results.(group).max_global_costE = zeros(boot_n,1);
    results.(group).max_local_costE = zeros(boot_n,1);
    
    %2. Maximum cost efficiency
    for j = 1 : boot_n
        results.(group).max_global_costE(j) = max(results.(group).global_costE(int_s:int_e,j));
        results.(group).max_local_costE(j) = max(results.(group).local_costE(int_s:int_e,j));
    end
    
    results.(group).mean.max_global_E = mean(results.(group).max_global_costE);
    results.(group).mean.max_local_E = mean(results.(group).max_local_costE);
    results.(group).std.max_global_E = std(results.(group).max_global_costE);
    results.(group).std.max_local_E = std(results.(group).max_local_costE);
    
end

% Return stats for a result from analyze_adni_weighted

i = 1;
for g1 = 1 : length(group_list);
    group1 = cell2mat(group_list(g1));
    for g2 = 1 : length(group_list);
        group2 = cell2mat(group_list(g2));
        if g1 < g2
            results.ttest.integral_global.groups(i,:)=[group_list(g1),group_list(g2)];
            
            % Integrals
            [h,p,~,stts]=ttest2(results.(group1).integral_global, results.(group2).integral_global);
            results.ttest.integral_global.t(i)=stts.tstat;
            results.ttest.integral_global.p(i)=p;
            
            [h,p,~,stts]=ttest2(results.(group1).integral_local, results.(group2).integral_local);
            results.ttest.integral_local.t(i)=stts.tstat;
            results.ttest.integral_local.p(i)=p;
            
            % Cost efficiency
            [h,p,~,stts]=ttest2(results.(group1).max_global_costE, results.(group2).max_global_costE);
            results.ttest.max_global_costE.t(i)=stts.tstat;
            results.ttest.max_global_costE.p(i)=p;
            [h,p,~,stts]=ttest2(results.(group1).max_local_costE, results.(group2).max_local_costE);
            results.ttest.max_local_costE.t(i)=stts.tstat;
            results.ttest.max_local_costE.p(i)=p;
            
            % Regional stats
             for j = 1 : R
%                 [h,p,~,stts]=ttest2(results.(group1).integral_reg_global(:,j), results.(group2).integral_reg_global(:,j));
%                 results.ttest.integral_reg_global.t(i,j)=stts.tstat;
%                 results.ttest.integral_reg_global.p(i,j)=p;
                 [h,p,~,stts]=ttest2(results.(group1).integral_reg_local(:,j), results.(group2).integral_reg_local(:,j));
                 results.ttest.integral_reg_local.t(i,j)=stts.tstat;
                 results.ttest.integral_reg_local.p(i,j)=p;
%                 [h,p,~,stts]=ttest2(results.(group1).integral_deg_centr(:,j), results.(group2).integral_deg_centr(:,j));
%                 results.ttest.integral_deg_centr.t(i,j)=stts.tstat;
%                 results.ttest.integral_deg_centr.p(i,j)=p;
%                 [h,p,~,stts]=ttest2(results.(group1).integral_betw_centr(:,j), results.(group2).integral_betw_centr(:,j));
%                 results.ttest.integral_betw_centr.t(i,j)=stts.tstat;
%                 results.ttest.integral_betw_centr.p(i,j)=p;
             end
            
            i = i + 1;
        end
    end
    
end

 % Bonferroni correction
 alpha = 0.05/(i - 1);
 results.ttest.integral_global.sig=results.ttest.integral_global.p < alpha;
 results.ttest.integral_local.sig=results.ttest.integral_local.p < alpha;

 % FDR for regions
%  results.ttest.integral_reg_global.fdr=fdr_bky(results.ttest.integral_reg_global.p);
  results.ttest.integral_reg_local.fdr=fdr_bky(results.ttest.integral_reg_local.p);
%  results.ttest.integral_deg_centr.fdr=fdr_bky(results.ttest.integral_deg_centr.p);
%  results.ttest.integral_betw_centr.fdr=fdr_bky(results.ttest.integral_betw_centr.p);
 
end