function [ new_values ] = convert_atlas_values( old_values, atlas_map )
%UNTITLED Converts a set of atlas indexes (e.g., an Nx1 vertex-wise atlas) to
%         new indices, specified by the Mx2 matrix atlas_map
%   Detailed explanation goes here

N = length(old_values);
M = size(atlas_map,1);

new_values = nan(N,1);

for i = 1 : M
   
    idx_old = atlas_map(i,1);
    idx_new = atlas_map(i,2);
    
    new_values(old_values == idx_old) = idx_new;
    
end

end

