load('lib/ImCalc.mat');

files = spm_select(2,'image','Select files for conjunction');

images{1} = strrep(files(1,:),' ','');
images{2} = strrep(files(2,:),' ','');

matlabbatch{1}.spm.util.imcalc.input = images;

[output_file,path] = uiputfile('*.*','Select output file');
output_file = fullfile(path,output_file);
if ~strcmp(output_file(end-3:end), '.nii'), output_file = [output_file '.nii']; end

matlabbatch{1}.spm.util.imcalc.output = output_file;

spm_jobman('run',matlabbatch)