function [ R, P, fdr ] = compute_seed_correlations ( Y, seed_mask, q )

% Compute vertex-wise correlations with the mean value from a seed mask
%
% INPUT:
%
% Y             is an N x V matrix, where N is # subjects and V is # vertices
% seed_mask     is a logical mask defining the seed region
% q             is the q threshold for FDR (default = 0.05)
%
% OUTPUT:
%
% M             is a N_vert x 1 vector of correlation coefficients
% P             is the corresponding vector of P values
% fdr           is a logical vector indicating whether coefficients survive
%               FDR correction (at threshold q)
%
%

if nargin < 3
   q = 0.05; 
end

N_vert = size(Y,2);

% Get seed average
seed_avr = mean(Y(:,seed_mask),2);

R = zeros(N_vert,1);
P = zeros(N_vert,1);

for i = 1 : N_vert
   
   [r,p] = corrcoef( seed_avr, Y(:,i) );
   
   R(i) = r(1,2);
   P(i) = p(1,2);
    
end

[~,fdr] = niak_fdr(P,'BY',q);