function [ result ] = compare_regional_means ( vals_1, vals_2 )

% Compares regional means across an N x P matrix, where N is the number of 
% subjects, and P is the number of regions. N1 and N2 can be different.

P = size ( vals_1, 2);

result.eff = zeros(P,1);
result.tval = zeros(P,1);
result.pval = zeros(P,1);
result.h = zeros(P,1);

for r = 1 : P
   
    [h, p, ci, stats] = ttest2( vals_1(:,r), vals_2(:,r) );
    
    result.eff(r) = mean(vals_1(:,r)) - mean(vals_2(:,r));
    result.tval(r) = stats.tstat;
    result.pval(r) = p;
    result.h(r) = h;
    
end