function [ h ] = bar_group_means( y_data, groups, group_names, param_names, error_type, y_label )
%BAR_GROUP_MEANS Plots mean & error as bars, for grouped data
%  
% PARAMETERS:
%
% y_data            Data to plot, N x P matrix, where N is the number of
%                   data points (e.g., subjects); P is the number of values
%                   per data point
% groups            Group assignments, N x 1 cell vector
% group_names       G x 1 vector of names of the groups to plot; these must 
%                   match the group assignments
% error_bars        Whether to plot error bars (default = true)
% error_type        Type of error to plot (one of 'std' or 'ste'); default
%                   is std
% colours           Group-wise colour assignments
%
% AUTHOR:
%  Andrew Reid, MNI, 2012
%

N = size(y_data,1);
P = size(y_data,2);
G = length(group_names);

if (~isempty(param_names))
    group_means = zeros(G,P);
    group_error = zeros(G,P);
else
    group_means = zeros(G,1);
    group_error = zeros(G,1);
end

if ~exist('y_label','var')
   y_label = 'Y values'; 
end

for i = 1 : G
    group = group_names(i);
    y_grp = y_data(strcmp(groups,group),:);
    if (isempty(param_names))
       y_grp = y_grp(:);            % collapse
    end
    group_means(i,:) = mean(y_grp);
    if strcmp(error_type,'std')
       group_error(i,:) = std(y_grp); 
    else
       group_error(i,:) = std(y_grp) / sqrt(N);
    end
    
end

figure;
barwitherr(group_error, group_means);

if ~isempty(param_names), legend(param_names); end;
set(gca,'XTickLabel',group_names);
ylabel(y_label);

end

