function [ output_files ] = ar_spm_translate_volumes( image_files, x, y, z, prefix, verbose, output_dir, subject )

%
%TRANSLATE_SPM_VOLUMES Translates a set of Nifti images with the specified
%x, y, and z offsets.


%   image_files         A list of paths to nifti-format image files
%   options.prefix      A prefix to prepend to the output file

count = length(image_files);

if nargin < 5
    prefix = 'spm_reoriented_';
end

output_files = cell(count,1);

% for each input file
for i = 1 : count
    
    file_in = cell2mat(image_files(i,:));
    try
        V = spm_vol(file_in);
        M0 = V.mat;
        P = [x y z 0 0 0 1 1 1 0 0 0];
        M = spm_matrix(P);
        M2 = M*M0;
        V2 = V;
        [pth,nam,ext] = fileparts(V.fname);
        if (isempty(output_dir))
            file_out = fullfile(pth,[prefix nam ext]);
        else
            file_out = fullfile(output_dir,subject,[prefix nam ext]);
        end
        output_files(i) = cellstr(file_out);
        V2.fname = file_out;
        V2.mat=M2;
        V2 = spm_create_vol(V2);
        for j=1:V.dim(3),
            M = inv(spm_matrix([0 0 -j]));
            img = spm_slice_vol(V,M,V.dim(1:2),1);
            spm_write_plane(V2,img,j);
        end;
     
    if (verbose)
        fprintf('%s\n', ['Processed ' file_in]);
    end
        
    catch err
       test = ['Could not process image ' file_in ': ' err.message];
       warning(test);
    end
end


end

