function [ output_files ] = ar_spm_normalize_volumes( V_temp, image_files, flags, verbose, output_dir, subject )

%NORMALIZE_SPM_VOLUMES Applies an SPM normalization to a set of images.

%   The normalization parameters are determined by a the first image in the 
%   list and the template image (V_temp). The resulting warp is applied to 
%   the list of images.
%
%      V_temp           The template image handle
%      image_files      Cell list of paths to the images on which to apply the 
%                       normalization
%      flags            Flags for spm_write_sn.m
%

count = length(image_files);

if nargin < 3
    flags        = spm_get_defaults('normalise.write');
    flags.prefix = 'spm_norm_';
    flags.bb=NaN*ones(2,3);
    flags.vox=[NaN NaN NaN];
end

V_src = spm_vol(cell2mat(image_files(1,:)));
params = spm_normalise(V_temp,V_src);

output_files = cell(count, 1);

% for each input file
for i = 1 : count
    
    file_in = cell2mat(image_files(i,:));
   % try
        V = spm_vol(file_in);
        V2 = V;
        [pth,nam,ext] = fileparts(V.fname);
        if (isempty(output_dir))
            file_out = fullfile(pth,[flags.prefix nam ext]);
        else
            file_out = fullfile(output_dir,subject,[flags.prefix nam ext]);
        end
        V2.fname = file_out;
        
        output_files(i) = cellstr(file_out);
        
        spm_write_sn(V, params, flags);

        if (verbose)
            fprintf('%s\n', ['Processed ' file_in]);
        end
%     catch err
%        test = ['Could not process image ' file_in ': ' err.message];
%        warning(test);
%     end
    
end

