function [ output_files ] = ar_spm_coregister_volumes( V_temp, image_files, flags, verbose, output_dir, subject )

%AR_SPM_COREGISTER_VOLUMES Applies an SPM coregistration (PET-to-T1) to a 
%                          set of images 
%
%      V_temp           The template image handle
%      image_files      Cell list of paths to the images on which to apply the 
%                       normalization
%      flags            Flags for spm_estimate.m and spm_reslice.m
%                       (Use spm_get_defaults('coreg'))

if nargin < 3
    flags        = spm_get_defaults('coreg');
    flags.write.prefix = 'spm_coreg_';
end

count = numel(image_files);

V_src = spm_vol(cell2mat(image_files(1,:)));
x = spm_coreg(V_temp, V_src, flags.estimate);
M  = spm_matrix(x);

MM = zeros(4,4,count);
output_files = cell(count, 1);

for j = 1 : count
    MM(:,:,j) = spm_get_space(image_files{j});
end

for j = 1 : count
    spm_get_space(image_files{j}, M\MM(:,:,j));
end

P = char(image_files);
spm_reslice(P,flags.write);

for i = 1 : count
    [pth,nam,ext,num] = spm_fileparts(image_files{i});
    if (isempty(output_dir))
        output_files{i} = fullfile(pth,[flags.write.prefix, nam, ext, num]);
    else
        output_files{i} = fullfile(output_dir, subject, [flags.write.prefix, nam, ext, num]);
    end
end

if (verbose)
    fprintf('%s\n', 'Coregistered images.');
end

end

